# Forward Target Propagation: A Forward-Only Approach to Global Error Credit Assignment via Local Losses


We introduce Forward Target Propagation (FTP), a biologically plausible and hardware-friendly alternative to backpropagation (BP) that uses forward-only computations for credit assignment. FTP eliminates the need for backward gradient propagation by using layer-wise local losses and feedforward target estimation. Our method is evaluated across multiple neural network architectures and learning paradigms, showing competitive performance to BP while offering significant advantages in efficiency and biological plausibility.

This repository includes experiments on three model families: fully connected networks (FC), convolutional neural networks (CNN), and recurrent neural networks (RNN).


## Requirements
Required environment is as the `requirements.txt` in this repository.


## Fully Connected Network
The notebook- `FullyConnected_FTP.ipynb` provides a tutorial-style implementation of FTP for image classification with fully connected layers. Replace MNIST with FMNIST/CIFAR10 to run FC for those datasets. Moreover, the corresponding changes, as mentioned in the notebook, are required.


## Convolutional Neural Network 

The experiments are run through `CNN_FTP.py`, which uses functions in `models.py`.

For example, to run FTP with the standard settings on the MNIST dataset:
```
python CNN_FTP.py --exp_name Experiment1 \
    --learn_type FTP --n_runs 1 --train_epochs 100 \
    --eta 0.01 --dropout 0.9 --Gstd 0.05 \
    --eta_decay --dataset mn --batch_size 50 \
    --update_type mom --w_init he_uniform \
    --model Net1conv1fcXL
``` 

The argument `Gstd` defines the standard deviation of the projection matrix.


## Recurrent Neural Network
The notebook- `RNN_FTP.ipynb` provides a tutorial-style implementation of FTP for time-series forecasting with RNN. For training the model with different datasets, the `dataset` variable on top of the Dataloader section needs to be changed according to the instructions in the notebook. The datasets are in `data` folder.


## Estimation of Multiply-Accumulate (MAC) Operations in FTP
The detailed estimations, including MAC computations for each model and learning procedure, are provided in the spreadsheet `MAC_analysis_FTP.ods`.





